# バッチ設計書 2-turbo run build

## 概要

本ドキュメントは、Turborepoを用いたモノレポ全体のビルドを実行する `turbo run build` コマンドのバッチ設計書である。各パッケージの依存関係を解析し、並列・キャッシュ付きでビルドタスクを実行する。

### 本バッチの処理概要

`turbo run build` は、Next.jsモノレポ内の全パッケージを依存関係順にビルドするバッチ処理である。Turborepoのタスクグラフ解析により、パッケージ間の依存関係を自動的に解決し、可能な限り並列でビルドを実行する。

**業務上の目的・背景**：Next.jsプロジェクトはモノレポ構成であり、`packages/next`、`packages/next-swc`、`packages/font`、`packages/eslint-plugin-next` 等の複数パッケージが相互に依存している。個別にビルドすると依存関係の順序管理が煩雑になるため、Turborepoにより依存解決と並列ビルド、ビルドキャッシュの活用を一括で管理する。リモートキャッシュ対応によりCI/CD環境でのビルド時間を大幅に短縮できる。

**バッチの実行タイミング**：随時実行。ブランチ切り替え後のリビルド、CI/CDパイプラインでの全体ビルド、リリース前のフルビルド等に使用される。

**主要な処理内容**：
1. turbo.json の読み込みとタスクグラフ構築
2. 各パッケージの依存関係解析（`^build` による依存パッケージの先行ビルド）
3. ローカルキャッシュおよびリモートキャッシュの確認
4. キャッシュミス時のパッケージビルド実行（並列）
5. ビルド成果物（`dist/**`）のキャッシュ保存
6. ビルドサマリーの出力

**前後の処理との関連**：`pnpm install` による依存関係インストール後に実行される。後続処理として、テスト実行（`pnpm test-*`）、リリース処理（`start-release`）、パッケージング（`pack-next`）等が行われる。`normalize-version-bump` がビルド前処理として先行実行されることがある。

**影響範囲**：モノレポ内の全パッケージの `dist/` ディレクトリ。Turborepoのキャッシュディレクトリ（`.turbo/`）にも影響する。

## バッチ種別

ビルド処理（モノレポ全体ビルド）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js がインストールされていること |
| pnpm インストール済み | pnpm パッケージマネージャーが利用可能であること |
| 依存関係インストール済み | `pnpm install` が完了していること |
| turbo.json | プロジェクトルートに turbo.json が存在すること |

### 実行可否判定

turbo.json の存在とパッケージワークスペースの構成が正しいこと。Turborepoが自動的にタスクグラフを検証する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --remote-cache-timeout | number | No | 60 | リモートキャッシュのタイムアウト秒数 |
| --summarize | boolean | No | true | ビルドサマリーを出力 |
| --filter | string | No | なし | 特定パッケージのみビルド |
| --force | boolean | No | false | キャッシュを無視して強制ビルド |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| turbo.json | JSON | Turborepoタスク定義・キャッシュ設定 |
| packages/*/package.json | JSON | 各パッケージの依存関係定義 |
| packages/*/src/ | TypeScript/JavaScript | 各パッケージのソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| packages/*/dist/ | ディレクトリ | 各パッケージのビルド成果物 |
| .turbo/ | ディレクトリ | Turborepoローカルキャッシュ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各パッケージの taskfile に依存 |
| 出力先 | packages/*/dist/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. turbo.json 読み込み
   └─ タスク定義（build: dependsOn: ["^build"], outputs: ["dist/**"]）
2. パッケージ依存関係解析
   └─ ワークスペース内の全パッケージの依存グラフ構築
3. キャッシュ確認
   └─ ローカルキャッシュ → リモートキャッシュの順に確認
4. タスク実行
   └─ 依存関係順に並列ビルド（キャッシュミスのパッケージのみ）
5. 成果物キャッシュ保存
   └─ dist/** をローカル/リモートキャッシュに保存
6. サマリー出力
   └─ 各パッケージのビルド結果（キャッシュヒット/ミス、所要時間）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: turbo run build] --> B[turbo.json 読み込み]
    B --> C[パッケージ依存関係解析]
    C --> D[タスクグラフ構築]
    D --> E{各パッケージ}
    E --> F{キャッシュヒット?}
    F -->|ヒット| G[キャッシュから復元]
    F -->|ミス| H[パッケージビルド実行]
    H --> I[成果物キャッシュ保存]
    G --> J{全パッケージ完了?}
    I --> J
    J -->|未完了| E
    J -->|完了| K[サマリー出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TURBO_TASK_FAILED | タスク失敗 | 個別パッケージのビルド失敗 | 失敗パッケージのビルドログを確認 |
| TURBO_CACHE_ERROR | キャッシュエラー | リモートキャッシュ接続失敗 | ネットワーク接続を確認、ローカルキャッシュで続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（Turborepo標準動作） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | リモートキャッシュ接続はタイムアウト後にスキップ |

### 障害時対応

ビルド失敗時は、失敗したパッケージのビルドログを確認する。`--force` フラグでキャッシュを無視した再ビルドを試みる。それでも解決しない場合は、`node_modules` の再インストール（`pnpm install`）を実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | パッケージ単位 |
| コミットタイミング | 各パッケージビルド完了時 |
| ロールバック条件 | 個別パッケージの失敗は他パッケージに影響しない（依存先を除く） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | モノレポ内の全パッケージ（約10-15パッケージ） |
| 目標処理時間 | キャッシュヒット時: 数秒、フルビルド: 数分 |
| メモリ使用量上限 | 並列実行数に依存 |

## 排他制御

Turborepoのキャッシュ機構により、同一入力に対するビルドは重複実行されない。ただし、同一マシン上での並列実行は `.turbo/` ディレクトリへの同時アクセスが発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | 対象パッケージ一覧、キャッシュ状態 |
| 進捗ログ | 各パッケージビルド時 | パッケージ名、キャッシュヒット/ミス |
| 終了ログ | ビルド完了時 | サマリー（所要時間、キャッシュ統計） |
| エラーログ | エラー発生時 | 失敗パッケージのビルドログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド時間 | プロジェクト依存 | CI/CDパイプライン通知 |
| 終了コード | 0以外 | CI/CDパイプライン失敗通知 |

## 備考

- 実行コマンド: `turbo run build --remote-cache-timeout 60 --summarize true`（package.json scripts.build）
- turbo.json でタスク定義: `"build": { "dependsOn": ["^build"], "outputs": ["dist/**"] }`
- 環境変数 `NEXT_CI_RUNNER` がglobalEnvとして定義されている
- daemon モードは無効（`"daemon": false`）
- リモートキャッシュを利用する場合はTurborepoの認証設定が必要
